﻿#include "precompiled.h"
#include "common.h"
#include "assert.h"

namespace RTCam {
	namespace Assert {
		void AssertFail(_In_z_ const char* condition, _In_z_ const char* msg, _In_z_ const char* file, int line)
		{
			const char* shortFilename = (strrchr(file, '\\') + 1);
			string errorMsg = StringFormat("%s: in %s on line %i\n", condition, shortFilename, line);
			if(msg) {
				errorMsg += string(msg) + "\n";
			}
			errorMsg += "Break here?\n";

			wstring errorMsgW = Utf8ToUtf16(errorMsg.c_str());

			int yesNo = MessageBox(nullptr, const_cast<wchar_t*>(errorMsgW.c_str()), L"Assert failed!", MB_YESNO);
			if(yesNo == IDYES) {
				DebugBreak();
			}
		}
	} // end namespace Assert
} // end namespace RTCam